<?php

namespace VM\ApiBundle\Controller;

use Import\ApiBundle\Entity\AllegroCategoryItem;
use Import\ApiBundle\Entity\AllegroCategoryItemType;
use Import\ApiBundle\Entity\PKD;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use FOS\RestBundle\Controller\Annotations as Rest;
use FOS\RestBundle\Controller\FOSRestController;
use FOS\RestBundle\Controller\Annotations\View;

use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use VM\ApiBundle\Entity\BankService;
use VM\ApiBundle\Entity\BankServiceOptions;
use VM\ApiBundle\Entity\Company;
use VM\ApiBundle\Entity\CompanyAllegroCategoryItem;
use VM\ApiBundle\Entity\CompanyBankServiceOption;
use VM\ApiBundle\Entity\CompanyBankServiceOptions;
use VM\ApiBundle\Entity\CompanyEmployee;
use VM\ApiBundle\Entity\CreatorStagesCompanyConfirm;
use VM\ApiBundle\Entity\Department;
use VM\ApiBundle\Entity\Employee;
use VM\ApiBundle\Entity\Round;
use VM\ApiBundle\Entity\User;
use VM\ApiBundle\Entity\UserCompanyRoleTypes;
use VM\ApiBundle\Entity\UserToken;
use VM\ApiBundle\Entity\UserTokenConfirmInfo;
use VM\ApiBundle\Entity\UserTokenList;
use VM\ApiBundle\Entity\UserTokens;
use VM\ApiBundle\Exceptions\ApiException;
use VM\FinancialStatementsBundle\Services\FinancialStatementGame;
use VM\FinancialStatementsBundle\Services\Restrictions\SegmentRestrictions;

class CreatorController extends AbstractController
{
    private $randomPlacesCount = 18;

    private $randomOffersCount = 20;

    private $randomEmployeesCount = 30;

    private $companyFund = 2000000;


    public function segmentAction()
    {
        /** @var SegmentRestrictions $SegmentRestrictions */
        $SegmentRestrictions = $this->get('segment.restrictions');

        $MarketSegment = $this->getUser()->getGroup()->getUser()->getmarketSegment();
        $SegmentRestrictions->setData($MarketSegment,$this->getApiGetter()->getUserCompanyOrFalse($this->getUser()));
        $SegmentRestrictions->generate();

//        $FinancialStatementGame = $this->get('vm_financial_statement_game');
//        $User = $this->getUser();
//        $Company = $this->getApiGetter()->getUserCompanyOrFalse($User);
//        $CurrentRound = $this->getApiGetter()->getUserActualRound($User);
//        $FinancialStatementGame->statement($CurrentRound,$Company);
//        print_r($FinancialStatementGame->getPrRFromDistributionSales());
//        die();

        echo "<pre>";
        print_r($SegmentRestrictions->getResults());
        echo '<br><br><br><br><br><br><br>';


        print_r($SegmentRestrictions->getResults()->getMaxProductionForDay());
        echo '<br><br>';
//        print_r($SegmentRestrictions->getResults()->restrictionsItems);
die();
//        $SegmentRestrictions->setData($MarketSegment,$this->getApiGetter()->getUserCompanyOrFalse($this->getUser()));
//        echo 'Valid='.$SegmentRestrictions->validate().'.<br>';
//        print_r($SegmentRestrictions->getValidData());
    }


    /**
     * @View(serializerGroups={"details"})
     */
    public function getCreatorStageAction($symbol)
    {
        return $this->getDoctrine()->getRepository('VMApiBundle:CreatorStages')->findOneBy(array('symbol' => $symbol));
    }

    /**
     * @View(serializerGroups={"details"})
     */
    public function getUsersInGroupForLoggedUserAction()
    {
        $User = $this->get('security.context')->getToken()->getUser();
        if(empty($User) || is_null($User->getGroupId()))
        {
            return array();
        }

        return $User->getGroup()->getUsers();
    }

    /**
     * @View(serializerGroups={"companyDetails"})
     */
    public function saveCompanyForLoggedUserAction()
    {
        $data = $this->getRequest()->request->get('data', null);

        $creatorCompletedFromRequest = $data['completed'];
        if(!isset($data['id']))
        {
            throw new \Exception('Brak parametru id firmy.', 1);
        }

        $CompanyId = (isset($data['id'])) ? (integer)$data['id'] : 0;
        /** @var Company $Company */
        $Company = $this->getDoctrine()->getRepository('VMApiBundle:Company')->find($CompanyId);
        $Round = $this->getApiGetter()->getGroupActualRound($Company->getUserGroups());
        if(empty($Company))
        {
            throw new \Exception('Firma nie istnieje.', 1);
        }

        if(!empty($Company) && $Company->getCreatorCompleted() && $creatorCompletedFromRequest !== true)
        {
            return new Response(json_encode(array('message' => 'Kreator tej firmy został już zakończony.')), 500);
        }
        else
        {
            $this->updateCompany($Company, $data);
            $this->unconfirmCreatorState($Company, 1);

            $this->getDoctrine()->getManager()->flush();
            $this->getDoctrine()->getManager()->clear();

            return $this->getDoctrine()->getRepository('VMApiBundle:Company')->find($CompanyId);
        }
    }

    /**
     * @View(serializerGroups={"companyDetails"})
     */
    public function getCompanyForLoggedUserAction()
    {
        $User = $this->get('security.context')->getToken()->getUser();
        if(empty($User) || is_null($User->getGroupId()))
        {
            return array();
        }

        if($User->getGroup()->getCompany()->isEmpty())
        {
            return $this->createCompany();
        }
        return $User->getGroup()->getCompany()->first();
    }


    /**
     * @View(serializerGroups={"companyDetails"})
     */
    public function getUserCompanyRoleTypesAction()
    {
        $UserCompanyRoleTypes = $this->getDoctrine()->getRepository('VMApiBundle:UserCompanyRoleTypes')->findAll();
        $return = array();
        foreach($UserCompanyRoleTypes as $type)
        {
            $return[$type->getSymbol()] = $type;
        }

        return $return;
    }

    /**
     * @View(serializerGroups={"companyDetails"})
     */
    public function companyConfirmStageAction()
    {
        $companyData = $this->getRequest()->request->get('company', null);
        $tokens = $this->getRequest()->request->get('tokens', null);
        $stageSymbol = $this->getRequest()->request->get('stageSymbol', null);

        if(is_null($tokens) || is_null($stageSymbol) || is_null($companyData))
        {
            throw new \Exception('error data', 1);
        }

        $Company = $this->get('security.context')->getToken()->getUser()->getGroup()->getCompany()->first();
        $companyId = $Company->getId();

        $CreatorStage = $this->getDoctrine()->getRepository('VMApiBundle:CreatorStages')->findOneBy(array('symbol' => $stageSymbol));

        $CreatorStagesCompanyConfirm = new CreatorStagesCompanyConfirm();

        $CreatorStagesCompanyConfirm->setCompany($Company);
        $CreatorStagesCompanyConfirm->setStage($CreatorStage);
        foreach($tokens as $tokenData)
        {
            $Token = $this->getToken($tokenData['id']);
            $CreatorStagesCompanyConfirm->addToken($Token);
            $Token->setCreatorStagesCompanyConfirm($CreatorStagesCompanyConfirm);
            $Token->setUsed(true);
            $this->getDoctrine()->getManager()->persist($Token);
        }

        $this->getDoctrine()->getManager()->persist($CreatorStagesCompanyConfirm);
        $this->getDoctrine()->getManager()->flush();
        $this->getDoctrine()->getManager()->clear();

        return $this->getDoctrine()->getRepository('VMApiBundle:Company')->find($companyId);
    }

    /**
     * @View(serializerGroups={"placeDetails"})
     */
    public function getRandomOffersAction()
    {
        $chattelSymbolList = array('KOMP','MOTO','PHONE','OTHER');

        foreach($chattelSymbolList as $chattelSymbol)
        {
            /** @var AllegroCategoryItemType $AllegroCategoryItemType */
            $AllegroCategoryItemType = $this->getDoctrine()->getRepository('ImportApiBundle:AllegroCategoryItemType')->findOneBy(array('symbol' => $chattelSymbol));

            $count = $AllegroCategoryItemType->getItems()->count();
            $randIndex = ($count > $this->randomOffersCount) ? rand(0,$count-$this->randomOffersCount) : 0;

            $chattel[$chattelSymbol] = array_values($AllegroCategoryItemType->getItems()->slice($randIndex,$this->randomOffersCount));
        }

        return $chattel;
    }

    /**
     * @View(serializerGroups={"placeDetails"})
     */
    public function getRandomPlacesAction()
    {
        $placeSymbolList = array('OFFICE','DEPOT','STOCKROOM');

        foreach($placeSymbolList as $placeSymbol)
        {
            /** @var AllegroCategoryItemType $AllegroCategoryItemType */
            $AllegroCategoryItemType = $this->getDoctrine()->getRepository('ImportApiBundle:AllegroCategoryItemType')->findOneBy(array('symbol' => $placeSymbol));

            $count = $AllegroCategoryItemType->getItems()->count();
            $randIndex = rand(1,$count-$this->randomPlacesCount);

            $places[$placeSymbol] = array_values($AllegroCategoryItemType->getItems()->slice($randIndex,$this->randomPlacesCount));
        }

        $Company = $this->getApiGetter()->getUserCompanyOrFalse($this->getUser());
        if($Company instanceof Company)
        {
            /** @var CompanyAllegroCategoryItem $CompanyAllegroCategoryItem */
            foreach($Company->getPlaces() as $CompanyAllegroCategoryItem)
            {
                if(in_array($CompanyAllegroCategoryItem->getItem()->getType()->getSymbol(), $placeSymbolList) && array_search($CompanyAllegroCategoryItem->getItem(), $places) === false)
                {
                    array_unshift($places[$CompanyAllegroCategoryItem->getItem()->getType()->getSymbol()], $CompanyAllegroCategoryItem->getItem());
                }
            }
        }

        return $places;
    }

    /**
     * @View(serializerGroups={"companyDetails"})
     */
    public function saveCheckedPlacesAction()
    {
        $placesList = $this->getRequest()->request->get('places', null);

        if(is_null($placesList))
        {
            throw new \Exception('error data', 1);
        }

        $ApiGetter = $this->getApiGetter();
        $User = $this->getUser();

        $Company = $ApiGetter->getUserCompanyOrFalse($User);
        $companyId = $Company->getId();

        $checkIsThisDuringCreator = $places = $this->getRequest()->request->get('during_creator', false);
        if($checkIsThisDuringCreator && $Company->getCreatorCompleted())
        {
            return new Response(json_encode(array('message' => 'Kreator tej firmy został już zakończony.')), 500);
        }

        $placesIds = array();
        if(!$Company->getPlaces()->isEmpty())
        {
            foreach($Company->getPlaces() as $place)
            {
                $placesIds[$place->getId()] = $place;
            }
        }
        $Round = $ApiGetter->getUserActualRound($User);


        foreach($placesList as $placeData)
        {
            if(isset($placeData['id']) && $placeData['id']>0)
            {
                $CompanyAllegroCategoryItem = $this->getCompanyAllegroCategoryItem($placeData['id']);
                if(isset($placeData['quantity']) && ($placeData['quantity']!=$CompanyAllegroCategoryItem->getQuantity()))
                {
                    $CompanyAllegroCategoryItem->setQuantity($placeData['quantity']);
                }
                unset($placesIds[$placeData['id']]);
            }
            else
            {
                $this->createCompanyAllegroCategoryItem($Company, $Round, $placeData);
            }
        }

        if(!empty($placesIds))
        {
            foreach($placesIds as $id=>$CompanyAllegroCategoryItem)
            {
                $Company->removePlace($CompanyAllegroCategoryItem);
                $this->getDoctrine()->getManager()->remove($CompanyAllegroCategoryItem);
            }
        }

        $this->unconfirmCreatorState($Company, 2);
        $this->getDoctrine()->getManager()->flush();
        $this->getDoctrine()->getManager()->clear();

        return $this->getDoctrine()->getRepository('VMApiBundle:Company')->find($companyId);
    }

    /**
     * @View(serializerGroups={"bankServiceDetails"})
     */
    public function getBankServicesAction()
    {
        return $this->getDoctrine()->getRepository('VMApiBundle:BankService')->findAll();
    }

    /**
     * @View(serializerGroups={"companyDetails"})
     */
    public function saveCompanyBankServiceOptionsAction()
    {
        $checkedBankServiceTypes = $places = $this->getRequest()->request->get('checkedBankServiceTypes', null);

        $Company = $this->getApiGetter()->getUserCompanyOrFalse($this->getUser());

        $checkIsThisDuringCreator = $places = $this->getRequest()->request->get('during_creator', false);
        if($checkIsThisDuringCreator && $Company->getCreatorCompleted())
        {
            return new Response(json_encode(array('message' => 'Kreator tej firmy został już zakończony.')), 500);
        }

        $companyId = $Company->getId();
        $this->saveCompanyBankServiceOptions($Company, $checkedBankServiceTypes);

        $userId = $this->getUser();
        $this->getDoctrine()->getManager()->persist($Company);
        $this->getDoctrine()->getManager()->flush();
        $this->getDoctrine()->getManager()->clear();

        $CurrentAccount = $this->getApiGetter()->getCompanyCurrentAccount($companyId);
        $Company = $this->getDoctrine()->getRepository('VMApiBundle:Company')->find($companyId);
        $User = $this->getDoctrine()->getRepository('VMApiBundle:User')->find($userId);
        $Round = $this->getApiGetter()->getUserActualRound($User);

        $accountChanges = $CurrentAccount->getAccountChanges();
        if(!empty($accountChanges))
        {
            foreach($CurrentAccount->getAccountChanges() as $AccountChange)
            {
                $this->getDoctrine()->getManager()->remove($AccountChange);
            }
        }
        $value = 2000000;

        $AccountChange = $this->getApiCreator()->createAccountChange($Round, $Company, $value, 'Saldo początkowe');
        $this->getDoctrine()->getManager()->persist($AccountChange);

        foreach($Company->getBankServiceOptions() as $CompanyBankServiceOption)
        {
            if($CompanyBankServiceOption->getOption()->getBankService()->getSymbol() == 'REVOLVING_LOAN')
            {
                $AccountChange = $this->getApiCreator()->createAccountChange($Round, $Company, $CompanyBankServiceOption->getValue(), 'Otwarcie kredytu obrotowego');
                $this->getDoctrine()->getManager()->persist($AccountChange);
                $value += $CompanyBankServiceOption->getValue();
            }

            if($CompanyBankServiceOption->getOption()->getBankService()->getSymbol() == 'INVESTMENT')
            {
                $AccountChange = $this->getApiCreator()->createAccountChange($Round, $Company, $CompanyBankServiceOption->getValue(), 'Otwarcie lokaty');
                $this->getDoctrine()->getManager()->persist($AccountChange);
                $value -= $CompanyBankServiceOption->getValue();
            }
        }

        $CurrentAccount->setValue($value);
        $this->unconfirmCreatorState($Company, 3);
        $this->getDoctrine()->getManager()->flush();
        $this->getDoctrine()->getManager()->clear();


        return $this->getDoctrine()->getRepository('VMApiBundle:Company')->find($companyId);
    }

    /**
     * @View()
     */
    public function getNumberListAndTokenAction($users)
    {
        $usersIds = explode(',',$users);
        $userTokensNumber = array();

        if(is_null($users) || empty($usersIds))
        {
            throw new \Exception('Not exist param users', 1);
        }

        foreach($usersIds as $userId)
        {
            $userTokensNumber[$userId] = $this->getNumberListAndTokenForUser($userId);
        }

        return $userTokensNumber;
    }

    /**
     * @View()
     */
    public function saveUsedTokensAction()
    {
        $this->getDoctrine()->getConnection()->beginTransaction();
        try
        {
            $tokens = $places = $this->getRequest()->request->get('tokens', null);
            $state = $this->getRequest()->request->get('state', 0);
            $tokensConfirmsMessage = $places = $this->getRequest()->request->get('tokensConfirmsMessage', '');
            $errors = array();
            $success = false;

            if(is_null($tokens))
            {
                throw new \Exception('Not exist param tokens', 1);
            }

            foreach($tokens as $token)
            {
                $firstToken = $this->getFirstTokenForUser($token['userId']);
                if(!$firstToken)
                {
                    continue;
                }
                if($firstToken->getToken() == $token['value'])
                {
                    $UserTokenConfirmInfo = new UserTokenConfirmInfo();
                    $UserTokenConfirmInfo->setUserToken($firstToken);
                    $UserTokenConfirmInfo->setInfo($tokensConfirmsMessage);

                    $firstToken->setUsed(1);
                    $firstToken->setConfirmInfo($UserTokenConfirmInfo);

                    $this->getDoctrine()->getManager()->persist($firstToken);
                    $this->getDoctrine()->getManager()->persist($UserTokenConfirmInfo);

                    $this->getDoctrine()->getManager()->flush();
                    $success = true;
                }
                else
                {
                    $errors[$token['userId']] = array(
                        'tokenListSeq' => $firstToken->getTokenList()->getSequence(),
                        'tokenSeq' => (empty($firstToken)) ? 0 : $firstToken->getSequence(),
                        'userId' => $token['userId'],
                        'token' => (empty($firstToken)) ? null : $firstToken->getToken(),
                        'code' => 1,
                        'message' => 'Błędny token'
                    );
                }
            }

            if($success)
            {
                $this->confirmCreatorState($this->getApiGetter()->getUserCompanyOrFalse($this->getUser()), $state);
                $this->getDoctrine()->getManager()->flush();
            }

            $this->getDoctrine()->getConnection()->commit();

            return array('success' => $success, 'errors' => $errors);

        }
        catch(\Exception $Exception)
        {
            $this->getDoctrine()->getConnection()->rollback();
            throw new ApiException($Exception->getMessage(), $Exception->getCode());
        }
    }

    /**
     * @View(serializerGroups={"employeesDetails"})
     */
    public function getRandomEmployeesListAction()
    {
        $count = $this->getDoctrine()->getRepository('VMApiBundle:Employee')->createQueryBuilder('e')->select('COUNT(e)')->getQuery()->getSingleScalarResult();
        $randId = rand(1,$count-$this->randomEmployeesCount);

        $QueryBuilder = $this->getDoctrine()->getRepository('VMApiBundle:Employee')->createQueryBuilder('e');
        $QueryBuilder
            ->select('e')
            ->where($QueryBuilder->expr()->eq('e.isWorker',0))
            ->andWhere($QueryBuilder->expr()->gt('e.id',$randId))
            ->setMaxResults($this->randomEmployeesCount)
        ;

        return $QueryBuilder->getQuery()->getResult();
    }

    /**
     * @View(serializerGroups={"departmentList"})
     */
    public function getDepartmentsListAction()
    {
        $AdminUser = $this->getUser()->getGroup()->getUser();
        $QueryBuilder = $this->getDoctrine()->getRepository('VMApiBundle:Department')->createQueryBuilder('d');
        $QueryBuilder
            ->select('d')
            ->andWhere('d.marketSegmentId = :marketSegmentId')
            ->setParameter('marketSegmentId', $AdminUser->getMarketSegmentId())
            ->orderBy('d.sequence')
        ;

        return $QueryBuilder->getQuery()->getResult();
    }

    /**
     * @View(serializerGroups={"companyDetails"})
     */
    public function saveEmployeesDepartmentForCompanyAction()
    {
        $departments = $places = $this->getRequest()->request->get('departments', null);
        if(is_null($departments))
        {
            throw new \Exception('Not exist param departments', 1);
        }

        $Company = $this->get('security.context')->getToken()->getUser()->getGroup()->getCompany()->first();
        $companyId = $Company->getId();

        $Company->getCompanyEmployees()->clear();

        $this->getDoctrine()->getManager()->flush();
        $this->getDoctrine()->getManager()->flush();
        $this->getDoctrine()->getManager()->clear();

        $Company = $this->getDoctrine()->getRepository('VMApiBundle:Company')->find($companyId);

        foreach($departments as $dIndex => $departmentData)
        {
            $Department = $this->getDepartment($departmentData['id']);
            if(!empty($departmentData['employees']))
            {
                foreach($departmentData['employees'] as $eIndex => $employeeData)
                {
                    $Employee = $this->getEmployee($employeeData['id']);
                    $Employee->setIsWorker(1);
                    $CompanyEmployee = $this->createCompanyEmployee($Company,$Department,$Employee);
                }
            }
        }

        $this->getDoctrine()->getManager()->flush();
        $this->getDoctrine()->getManager()->clear();

        return $this->getDoctrine()->getRepository('VMApiBundle:Company')->find($companyId);
    }

    /**
     * @View(serializerGroups={"pkdList"})
     * @return array
     */
    public function getActiveCodesPkdAction()
    {
        return $this->getDoctrine()->getRepository('ImportApiBundle:PKD')->findBy(array('active'=>1));
    }

    /**
     * @View()
     * @return array
     */
    public function endCreatorCheckAction()
    {
        $Company = $this->getApiGetter()->getUserCompanyOrFalse($this->getUser());

        $creatorState = $Company->getCreatorState();

        $errors = array();

        if(($creatorState & 1) == 0)
        {
            $errors[] = 'Pierwszy etap - Notariusz - nie został jeszcze potwierdzony';
        }
        if(($creatorState & 2) == 0)
        {
            $errors[] = 'Drugi etap - Nieruchomości - nie został jeszcze potwierdzony';
        }
        if(($creatorState & 4) == 0)
        {
            $errors[] = 'Trzeci etap - Bank - nie został jeszcze potwierdzony';
        }


        return array('states_confirmed' => (count($errors) == 0) ? true : false, 'errors' => $errors);
    }

    /**
     * @View()
     * @return array
     */
    public function endCreatorAction()
    {
        $Company = $this->getApiGetter()->getUserCompanyOrFalse($this->getUser());

        $creatorState = $Company->getCreatorState();

        if($creatorState == 7)
        {
            $Company->setCreatorCompleted(true);
        }

        $this->getDoctrine()->getManager()->flush();

        return $Company->getCreatorCompleted();
    }

    /**
     * @return Company
     */
    private function createCompany()
    {
        $User = $this->get('security.context')->getToken()->getUser();

        $Company = new Company();

        $Company->setCreateUser($User);
        $Company->setUserGroups($User->getGroup());

        $this->setCompanyFund($Company);

        $this->getDoctrine()->getManager()->persist($Company);
        $this->getDoctrine()->getManager()->flush();
        $this->getDoctrine()->getManager()->refresh($Company);

        $companyId = $Company->getId();
        $this->getDoctrine()->getManager()->clear();
        $Company = $this->getDoctrine()->getRepository('VMApiBundle:Company')->find($companyId);

        return $Company;
    }

    private function setCompanyFund(Company $Company)
    {
        $flagFund = 'RB';
        $BankServices = $this->getDoctrine()->getRepository('VMApiBundle:BankService')->findAll();

        foreach($BankServices as $BankService)
        {
            foreach($BankService->getTypes() as $Option)
            {
                $flags = explode(',',$Option->getFlags());
                if(in_array($flagFund,$flags))
                {
                    $CompanyBankServiceOption = new CompanyBankServiceOption();

                    $CompanyBankServiceOption->setCompany($Company);
                    $CompanyBankServiceOption->setRound($this->getApiGetter()->getUserActualRound($this->getUser()));
                    $CompanyBankServiceOption->setOption($Option);
                    $CompanyBankServiceOption->setValue($this->companyFund);

                    $Company->addBankServiceOption($CompanyBankServiceOption);

                    $this->getDoctrine()->getManager()->persist($CompanyBankServiceOption);
                }

            }
        }
    }

    private function updateCompany(Company $Company, $data)
    {
        if(isset($data['name']))
        {
            $Company->setName($data['name']);
        }
        if(isset($data['address']))
        {
            $Company->setAddress($data['address']);
        }
        if(isset($data['codes_pkd'])||!empty($data['codes_pkd']))
        {
            $this->saveCodesPkdToCompany($Company,$data['codes_pkd']);
        }
        if(isset($data['representation_number']))
        {
            $Company->setRepresentationNumber($data['representation_number']);
        }
        if(isset($data['include_chef_in_representation']))
        {
            $Company->setIncludeChefInRepresentation($data['include_chef_in_representation']);
        }
        if(isset($data['production_price']))
        {
            $Company->setProductionPrice($data['production_price']);
        }
        if(isset($data['change_production_cost']))
        {
            $Company->setChangeProductionCost($data['change_production_cost']);
        }
        if(isset($data['production_amount']))
        {
            $Company->setProductionAmount($data['production_amount']);
        }
        if(isset($data['reports']))
        {
            $Company->setReports($data['reports']);
        }

        $usersGroupAsoc = array();
        foreach($data['user_groups']['users'] as $userData)
        {
            $usersGroupAsoc[$userData['id']] = $userData;
        }

        foreach($Company->getUserGroups()->getUsers() as $User)
        {
            $rolesData = $usersGroupAsoc[$User->getId()]['company_roles'];
            $roleDataAsoc = array();
            foreach($rolesData as $role)
            {
                $roleDataAsoc[$role['symbol']] = $role;
            }

            //update company roles
            if(!$User->getCompanyRoles()->isEmpty())
            {
                foreach($User->getCompanyRoles() as $Role)
                {
                    if(isset($roleDataAsoc[$Role->getSymbol()]))
                    {
                        unset($roleDataAsoc[$Role->getSymbol()]);
                    }
                    else
                    {
                        $User->removeCompanyRole($Role);
                        $this->getDoctrine()->getManager()->persist($User);
                    }
                }
            }

            if(!empty($roleDataAsoc))
            {

                foreach($roleDataAsoc as $symbol => $roleData)
                {
                    $User->addCompanyRole($this->getUserCompanyRoleTypesBySymbol($symbol));
                    $this->getDoctrine()->getManager()->persist($User);
                }
            }
        }

        $Company->setCompleted($this->validateCompany($Company));
    }

    private function saveCodesPkdToCompany(Company $Company,$codesPkdData)
    {
        $codesPkdDataAsoc = array();
        foreach($codesPkdData as $pkd)
        {
            $codesPkdDataAsoc[$pkd['id']] = $pkd;
        }
        if(!$Company->getCodesPkd()->isEmpty())
        {
            foreach($Company->getCodesPkd() as $Pkd)
            {
                if(isset($codesPkdDataAsoc[$Pkd->getId()]))
                {
                    unset($codesPkdDataAsoc[$Pkd->getId()]);
                }
                else
                {
                    $Company->removeCodesPkd($Pkd);
                }
            }
        }
        if(!empty($codesPkdDataAsoc))
        {
            foreach($codesPkdDataAsoc as $id => $pkdData)
            {
                $Company->addCodesPkd($this->getPkd($id));

                $this->getDoctrine()->getManager()->persist($Company);
            }
        }
    }

    private function saveCompanyBankServiceOptions(Company $Company, $optionsData)
    {
        $Round = $this->getApiGetter()->getUserActualRound($this->getUser());
        $optionsDataAsoc = array();
        foreach($optionsData as $option)
        {
            if(isset($option['id']))
            {
                $optionsDataAsoc[$option['id']] = $option;
            }
            else
            {
                $Option = $this->getOption($option['option']['id']);
                if($Option->getBankService()->getSymbol() == 'CURRENT_ACCOUNT')
                {
                    $CompanyBankServiceOption = $this->getApiGetter()->getCompanyCurrentAccount($Company->getId());
                    $optionsDataAsoc[$CompanyBankServiceOption->getId()] = $option;
                    $CompanyBankServiceOption->setOption($Option);
                }
                else
                {
                    $CompanyBankServiceOption = new CompanyBankServiceOption();

                    $CompanyBankServiceOption->setCompany($Company);
                    $CompanyBankServiceOption->setRound($Round);
                    $CompanyBankServiceOption->setOption($Option);
                    $CompanyBankServiceOption->setValue(isset($option['value']) ? (int)$option['value'] : 0);

                    $this->getDoctrine()->getManager()->persist($CompanyBankServiceOption);
                }

            }
        }
        if(!$Company->getBankServiceOptions()->isEmpty())
        {
            foreach($Company->getBankServiceOptions() as $Option)
            {
                if(isset($optionsDataAsoc[$Option->getId()]))
                {
                    if(isset($optionsDataAsoc[$Option->getId()]['value']))
                    {
                        $Option->setValue((int)$optionsDataAsoc[$Option->getId()]['value']);
                    }
                    unset($optionsDataAsoc[$Option->getId()]);
                }
                else
                {
                    //echo $Option->getId();
                    $Company->removeBankServiceOption($Option);
                }
            }
        }
        if(!empty($optionsDataAsoc))
        {
            foreach($optionsDataAsoc as $id => $optionData)
            {
                $CompanyBankServiceOption = new CompanyBankServiceOption();

                $CompanyBankServiceOption->setCompany($Company);
                $CompanyBankServiceOption->setOption($this->getOption($optionData['option']['id']));
                $CompanyBankServiceOption->setValue(isset($optionData['value']) ? (int)$optionData['value'] : 0);

                $this->getDoctrine()->getManager()->persist($CompanyBankServiceOption);

                $Company->addBankServiceOption($CompanyBankServiceOption);
            }
        }

    }


    /**
     * @param Company $Company
     * @param Round $Round
     * @param $placesData
     * @return CompanyAllegroCategoryItem
     */
    private function createCompanyAllegroCategoryItem(Company $Company, Round $Round, $placesData)
    {
        $Item = $this->getAllegroCategoryItem($placesData['item_id']);
        $CompanyAllegroCategoryItem = new CompanyAllegroCategoryItem();

        $CompanyAllegroCategoryItem->setCompany($Company);
        $CompanyAllegroCategoryItem->setRound($Round);
        $CompanyAllegroCategoryItem->setItem($Item);
        $CompanyAllegroCategoryItem->setQuantity((isset($placesData['quantity']) ? $placesData['quantity'] : 1));
        $CompanyAllegroCategoryItem->setPrice($Item->getBuyNowPrice());

       $this->getDoctrine()->getManager()->persist($CompanyAllegroCategoryItem);

        return $CompanyAllegroCategoryItem;
    }

    /**
     * @param Company $Company
     * @param Department $Department
     * @param Employee $Employee
     * @return CompanyEmployee
     */
    private function createCompanyEmployee(Company $Company,Department $Department,Employee $Employee)
    {
        $CompanyEmployee = new CompanyEmployee();
        $CompanyEmployee->setCompany($Company);
        $CompanyEmployee->setDepartment($Department);
        $CompanyEmployee->setEmployee($Employee);

        $this->getDoctrine()->getManager()->persist($CompanyEmployee);

        return $CompanyEmployee;
    }

    private function getUserCompanyRoleTypesBySymbol($symbol)
    {
        return $UserCompanyRoleTypes = $this->getDoctrine()->getRepository('VMApiBundle:UserCompanyRoleTypes')->findOneBy(array('symbol' => $symbol));
    }

    private function validateCompany(Company $Company)
    {
        if(is_null($Company->getName()))
        {
            return false;
        }
        if(is_null($Company->getCodesPkd()))
        {
            return false;
        }
        if(is_null($Company->getRepresentationNumber()) || $Company->getRepresentationNumber() < 1)
        {
            return false;
        }

        return true;
    }

    /**
     * @param $userId
     * @return UserToken
     * @throws \Exception
     */
    private function getFirstTokenForUser($userId)
    {
        $User = $this->getDoctrine()->getRepository('VMApiBundle:User')->find($userId);
        if(empty($User))
        {
            throw new \Exception('User not exist', 1);
        }

        $ActiveTokensList = $User->getTokensList()->filter(function($TokensList) {return $TokensList->getIsActive();})->first();
        $NotUsedTokens = $ActiveTokensList->getTokens()->filter(function($Token) {return !$Token->getUsed();});

        return $NotUsedTokens->first();
    }

    private function getNumberListAndTokenForUser($userId)
    {
        $token = $this->getFirstTokenForUser($userId);
        $User = $this->getDoctrine()->getRepository('VMApiBundle:User')->find($userId);
        $ActiveTokensList = $User->getTokensList()->filter(function($TokensList) {return $TokensList->getIsActive();})->first();

        return array(
            'tokenListSeq' => (empty($token)) ? $ActiveTokensList->getSequence() : $token->getTokenList()->getSequence(),
            'tokenSeq' => (empty($token)) ? 0 : $token->getSequence(),
            'userId' => $userId,
            'token' => (empty($token)) ? null : md5($token->getToken()),
        );
    }

    /**
     * @param $id
     * @return UserTokens
     * @throws \Exception
     */
    private function getToken($id)
    {
        $Token = $this->getDoctrine()->getRepository('VMApiBundle:UserTokens')->find($id);
        if(empty($Token))
        {
            throw new \Exception('Token not exist', 1);
        }
        return $Token;
    }

    /**
     * @param $id
     * @return AllegroCategoryItem
     * @throws \Exception
     */
    private function getPlace($id)
    {
        $Place = $this->getDoctrine()->getRepository('ImportApiBundle:AllegroCategoryItem')->find($id);
        if(empty($Place))
        {
            throw new \Exception('place not exist', 1);
        }
        return $Place;
    }

    /**
     * @param $id
     * @return BankServiceOptions
     * @throws \Exception
     */
    private function getOption($id)
    {
        $Option = $this->getDoctrine()->getRepository('VMApiBundle:BankServiceOptions')->find($id);
        if(empty($Option))
        {
            throw new \Exception('Option not exist', 1);
        }
        return $Option;
    }

    /**
     * @param $id
     * @return Department
     * @throws \Exception
     */
    private function getDepartment($id)
    {
        $Department = $this->getDoctrine()->getRepository('VMApiBundle:Department')->find($id);
        if(empty($Department))
        {
            throw new \Exception('Department not exist', 1);
        }
        return $Department;
    }

    /**
     * @param $id
     * @return Employee
     * @throws \Exception
     */
    private function getEmployee($id)
    {
        $Employee = $this->getDoctrine()->getRepository('VMApiBundle:Employee')->find($id);
        if(empty($Employee))
        {
            throw new \Exception('Employee not exist', 1);
        }
        return $Employee;
    }

    /**
     * @param $id
     * @return PKD
     * @throws \Exception
     */
    private function getPkd($id)
    {
        $Pkd = $this->getDoctrine()->getRepository('ImportApiBundle:PKD')->find($id);
        if(empty($Pkd))
        {
            throw new \Exception('Pkd not exist', 1);
        }
        return $Pkd;
    }

    /**
     * @param $id
     * @return AllegroCategoryItem
     * @throws \Exception
     */
    private function getAllegroCategoryItem($id)
    {
        $AllegroCategoryItem = $this->getDoctrine()->getRepository('ImportApiBundle:AllegroCategoryItem')->find($id);
        if(empty($AllegroCategoryItem))
        {
            throw new \Exception('AllegroCategoryItem not exist', 1);
        }
        return $AllegroCategoryItem;
    }

    /**
     * @param $id
     * @return CompanyAllegroCategoryItem
     * @throws \Exception
     */
    private function getCompanyAllegroCategoryItem($id)
    {
        $CompanyAllegroCategoryItem = $this->getDoctrine()->getRepository('VMApiBundle:CompanyAllegroCategoryItem')->find($id);
        if(empty($CompanyAllegroCategoryItem))
        {
            throw new \Exception('CompanyAllegroCategoryItem not exist', 1);
        }
        return $CompanyAllegroCategoryItem;
    }


    private function test(\Doctrine\ORM\QueryBuilder $QueryBuilder)
    {
        $QueryBuilder->setMaxResults(20);
    }


    /**
     * @param Company $Company
     * @param $state
     */
    protected function confirmCreatorState(Company $Company, $state)
    {
        $creatorState = (integer)$Company->getCreatorState();

        $newState = 0;
        switch($state)
        {
            case 1:
                $newState = 1;
                break;
            case 2:
                $newState = 2;
                break;
            case 3:
                $newState = 4;
                break;
            case 4:
                $newState = 8;
                break;
        }

//        var_dump($binary, $newState, ($binary & $newState));
        if(($creatorState & $newState) == 0)
        {
            $Company->setCreatorState($creatorState + $newState);
//            throw new \Exception('#' . $binary . '#' . $newState . '#' . ($binary | $newState) . '#' . $Company->getCreatorCompleted());
        }
//        else
//        {
//            throw new \Exception('Etap zakończony');
//        }

    }


    /**
     * @param Company $Company
     * @param $state
     */
    protected function unconfirmCreatorState(Company $Company, $state)
    {
        $creatorState = (integer)$Company->getCreatorState();

        $newState = 0;
        switch($state)
        {
            case 1:
                $newState = 1;
                break;
            case 2:
                $newState = 2;
                break;
            case 3:
                $newState = 4;
                break;
            case 4:
                $newState = 8;
                break;
        }

        if(($creatorState & $newState) != 0)
        {
            $Company->setCreatorState($creatorState - $newState);
        }
    }
}